using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Xanthos.Evo
{
	public class EvoSpiderDust : BaseEvoDust
	{
		[Constructable]
		public EvoSpiderDust() : this( 1 )
		{
		}

		[Constructable]
		public EvoSpiderDust( int amount ) : base( amount )
		{
			Amount = amount;
			Name = "Spider Dust";
			Hue = 986;
		}

		public EvoSpiderDust( Serial serial ) : base ( serial )
		{
		}

		public override BaseEvoDust NewDust()
		{
			return new EvoSpiderDust();
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}